/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.npcs.LogWriter;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.entity.EntityNPCInterface;

public class CmdSlay
extends CommandNoppesBase {
    public Map<String, Class<?>> slayMap = new HashMap();

    @Override
    public int func_82362_a() {
        return 2;
    }

    public CmdSlay() {
        this.slayMap.put("all", EntityLivingBase.class);
        this.slayMap.put("mobs", EntityMob.class);
        this.slayMap.put("animals", EntityAnimal.class);
        this.slayMap.put("items", EntityItem.class);
        this.slayMap.put("xporbs", EntityXPOrb.class);
        this.slayMap.put("npcs", EntityNPCInterface.class);
        for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
            String name = ent.getName();
            Class cls = ent.getEntityClass();
            if (EntityNPCInterface.class.isAssignableFrom(cls) || !EntityLivingBase.class.isAssignableFrom(cls)) continue;
            this.slayMap.put(name.toLowerCase(), cls);
        }
        this.slayMap.remove("monster");
        this.slayMap.remove("mob");
    }

    private boolean delete(Entity entity, ArrayList<Class<?>> toDelete) {
        for (Class<?> delete : toDelete) {
            if (delete == EntityAnimal.class && entity instanceof EntityHorse || !delete.isAssignableFrom(entity.getClass())) continue;
            entity.field_70128_L = true;
            return true;
        }
        return false;
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("/noppes slay " + this.getUsage()));
            return;
        }
        ArrayList toDelete = new ArrayList();
        boolean deleteNPCs = false;
        for (String delete : args) {
            Class<?> cls = this.slayMap.get(delete = delete.toLowerCase());
            if (cls != null) {
                toDelete.add(cls);
            }
            if (delete.equals("mobs")) {
                toDelete.add(EntityGhast.class);
                toDelete.add(EntityDragon.class);
            }
            if (!delete.equals("npcs")) continue;
            deleteNPCs = true;
        }
        int count = 0;
        int range = 120;
        try {
            range = Integer.parseInt(args[args.length - 1]);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        AxisAlignedBB box = new AxisAlignedBB(sender.func_180425_c(), sender.func_180425_c().func_177982_a(1, 1, 1)).func_72314_b((double)range, (double)range, (double)range);
        List list = new ArrayList();
        try {
            list = sender.func_130014_f_().func_72872_a(EntityLivingBase.class, box);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Entity entity : list) {
            if (entity instanceof EntityPlayer || entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n() || entity instanceof EntityNPCInterface && !deleteNPCs || !this.delete(entity, toDelete)) continue;
            ++count;
        }
        if (toDelete.contains(EntityXPOrb.class)) {
            list.clear();
            try {
                list = sender.func_130014_f_().func_72872_a(EntityXPOrb.class, box);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Entity entity : list) {
                entity.field_70128_L = true;
                ++count;
            }
        }
        if (toDelete.contains(EntityItem.class)) {
            list.clear();
            try {
                list = sender.func_130014_f_().func_72872_a(EntityItem.class, box);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Entity entity : list) {
                entity.field_70128_L = true;
                ++count;
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(count + " entities deleted", new Object[0]));
    }

    @Override
    public String getDescription() {
        return "Kills given entity within range. Also has all, mobs, animal options. Can have multiple types";
    }

    @Override
    @Nonnull
    public String func_71517_b() {
        return "slay";
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, BlockPos pos) {
        return CommandBase.func_71530_a((String[])args, (String[])this.slayMap.keySet().toArray(new String[0]));
    }

    @Override
    public String getUsage() {
        return "<type>.. [range]";
    }
}

